* Title: 	figure3.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of change in incomes by conspuma


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure3, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma PrimeMaleD inctot_real perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 1980 Census and 2009-2011 ACS
keep if year == 1980 | (year>=2009 & year<=2011)

* Pool data for 2009-2011 ACS
replace year = 2010 if year>=2009 & year<=2011

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Fix coding due to post-2006 PUMA change due to Katrina
replace conspuma = 172 if conspuma == 173


*******************************************************************************
* (2) Construct median income variables for 1980/2010
*******************************************************************************

collapse (median) Income_Median = inctot_real ///
		 (p10)    Income_p10 = inctot_real ///
		 (p90)    Income_p90 = inctot_real ///
		 [pw=perwt], by(year statefip conspuma)

foreach var of varlist Income_Median Income_p10 Income_p90 {
	gen Log_`var' = log(`var')
	drop `var'
}

reshape wide Log_Income_*, i(statefip conspuma) j(year)
ren (*1980 *2010) (*_1980 *_2010)
gen Delta_LogIncome = Log_Income_Median_2010 - Log_Income_Median_1980
 

* Save dataset
keep statefip conspuma Log_Income_Median_1980 Log_Income_p10_1980 Log_Income_p90_1980 Delta_LogIncome
compress
save output/figures/dta/figure3.dta, replace


*******************************************************************************
* (3) Produce regressions/graph
*******************************************************************************

* Log income regression
reg Delta_LogIncome Log_Income_Median_1980, vce(cluster statefip)

* IV regression
ivreg Delta_LogIncome (Log_Income_Median_1980 = Log_Income_p10_1980 Log_Income_p90_1980), first cluster(statefip)

scatter Delta_LogIncome Log_Income_Median_1980 || lfit Delta_LogIncome Log_Income_Median_1980, ///
		legend(label(1 "PUMA") label(2 "Best Fit")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Log median income, 1980") ytitle("Change in log median income, 1980-2010")
		
graph save output/figures/gph/figure3, replace
graph export output/figures/eps/figure3.eps, as(eps) replace
export excel using output/figures/xlsx/figure3.xlsx, first(variables) replace
 

*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
